// SimpleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Simple.h"
#include "SimpleDlg.h"
#include "ieee_32.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSimpleDlg dialog

CSimpleDlg::CSimpleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSimpleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSimpleDlg)
	m_response = _T("");
	m_addr = 0;
	m_command = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSimpleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSimpleDlg)
	DDX_Text(pDX, IDC_RESPONSE, m_response);
	DDX_Text(pDX, IDC_ADDRESS, m_addr);
	DDV_MinMaxUInt(pDX, m_addr, 1, 31);
	DDX_Text(pDX, IDC_COMMAND, m_command);
	DDV_MaxChars(pDX, m_command, 15);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSimpleDlg, CDialog)
	//{{AFX_MSG_MAP(CSimpleDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSimpleDlg message handlers

BOOL CSimpleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
     // init the GPIB board
	 initialize (21,0);      /* make PC a controller at address 21 */
	// set our edit boxes equal to default values
	m_addr = 16;
	m_command = "*IDN?";  // default command
	UpdateData(FALSE);  // update the dialog with our values
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSimpleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSimpleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSimpleDlg::OnOK() 
{


    int status,l;
    char r[80];
		
	UpdateData(TRUE); // get current values from the dialog, e.g., address and command
 
    strcpy(r,m_command);  // copy our string to the char array used by send command
    
    send (m_addr,r,&status);     /* send the command */
    enter (r,80,&l,m_addr,&status);    /* read response */
	// TODO: read response only if last character was ?

	m_response = r;   // make edit box equal to our character array, r
    UpdateData(FALSE);  // update the dialog
	
}

void CSimpleDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}
